<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "setting".
 *
 * @property integer $id
 * @property string $name
 * @property string $value
 */
class Settings extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'settings';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'string'],
            [['value'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'value' => Yii::t('app', 'Value'),
        ];
    }

    public function getSettingValue($name)
    {
        $s = Settings::find(['name'=>$name])->one();
        if($s){
            return $s['value'];
        }else{
            return null;
        }
    }

    public function setSettingValue($name, $value)
    {
        $s = Settings::findOne(['name'=>$name]);
        if($s){
            $s->value = $value;
            $s->save(false);
        }else{
            $ss = New Settings();
            $ss->name = $name;
            $ss->value = $value;
            $ss->save(false);
        }
    }

}
